/*
This is to FIT a NEATM to WISE magnitudes
M. Delbo, V. Ali Spet 2011: Tenerife
last update Sept 1, Tenerife
 */
#define NRANSI
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "../tms/tm.h"
#include "../tms/constants.h"
#include "../tms/macros.h"
#include "filter.h"

#define	 NITER		250
#define  NMAX           1000
#define  MA             3
#define	 TSS_RANGE      0.3
#define	 TSS_STEP       10
#define  V2IR_MIN       0.2  // to fit the vtobandratio
#define  V2IR_MAX       3.6
#define  V2IR_STEP      0.2



#define USAGE "\n"
#define ADARGS "-l <lambda0> <lambda1> <lambdastep> to change the default wavelenght range\n\
 -m mode 0=NEATM 2=STM 3=FRM\n\
 -e <emissivity value>\n\
 -g <G_value>\n\
 -o <output_filename>\n\
 -r column mode\n\
 -b <beta_e> \n\
 -v verbose mode\n\
 -V <VtoBandsRatio>\n"

#define PROG     "FitTM"
#define AUTHOR   "Marco Delbo"
#define VERSION  "beta 1.0"
#define REL_DATE "January 10, 2008"


///////////////////////////////////////////////////////////////////////
// fit the Near Earth Asteroid Thermal Model to WISE IsoPhotal fluxes//
//////////////////////////////////////////////////////////////////////
//
// Marco Delbo Victor Ali
//
int NEATMFitWISE(FILTER *Filter,	// list of available filters 
		 int    *FiltIndex,     // zero based fiter indes
		 double *f,		// flux vector
		 double *ef,		// error on flux vector
		 int    nFilter,       	// number of elements in the filter index vector
		 double *R,		// Radius of the asteroid in km (1.fit param)
		 double *eR,		// Error on Diameter
		 double *Pv,		// Geometric Albedo
		 double *ePv,		// error on Pv
		 double H,	       	// H value
		 double *eta,		// eta value
		 double *eeta,		// error on eta value
		 double epsilon,       	// emissivity
		 double Delta,		// distance from the earth
		 double r,	       	// distance from the sun
		 double alfa,		// phase angle
		 double G,		// G value
		 double *pChisq,       	// Chi squared value of the fit
		 double *Tss,           // subsolar temperature
		 int    N,	       	// number of iterations
		 int    mode)		// mode e.g Verbose
{
  double  pv=*Pv;		       	// use the user-provided guess albedo.
  double  A=Pv2A(*Pv, G);		// derive the Bolometric Bond's Albedo; 
  double  TssLow, TssHi;
  int	  NN;
  double  *TssBuffer,*pcs=NULL;
  double  *fr=NULL;
  double  beginchisq, bestchisq, chisq=0.0;
  double  Dsq, Dsqbest, DsqDen;
  int	  i,j,k;
  double  num, den;
  double  a, b, x[3], y[3];
  double  *flux; // fluxbuffer for filter calculation
  double  *colorcorrection;
	
  *R=H2DIAM(H, *Pv)/2.0;		// calculate an Initial diameter from the H value and Guess pV

  if (eta[0]>0) 
    *Tss=TSS(A, *eta, r, epsilon);    // Force Tss to the value imposed by the user
  else
    *Tss=TSS(A, 1.0, r, epsilon);    // starts with a Tss given by eta=1
 
  TssLow = floor(Tss[0]*(1-TSS_RANGE));
  TssHi=ceil(Tss[0]*(1+TSS_RANGE));
  NN=(int)((TssHi-TssLow)/TSS_STEP) + 1;

  printf("fuck %lf %lf %lf %lf %d\n", A, Tss[0], TssLow, TssHi, NN);

  if (mode & TM_MODE_VERBOSE) 
    {
      if (*eta>0) printf("Entering NEATMfit for WISE with Tss=%lf FIXED\n", *Tss);
      else printf("Entering NEATMfit for WISE and performing beaming paramter FIT\n\
                   Maximum N of points for eta is %d\n",NN);
    }
  
  if (N > 10000) {printf("More than 10000 iterations??? \n qutting\n"); return -1;}
  if (nFilter<=0) {printf("No data?? quitting\n"); return -1; }
  if (pv<=0) pv=0.01;//reset pV to low albedo object 
  
  if ( (flux=(double*)malloc(sizeof(double)*5000)) == NULL) // alloc reference monocromatic flux vector for the NEATM output
    {
      printf("malloc error 1540 \n");
      return -1;
    }
  
  if ( (fr=(double*)malloc(sizeof(double)*nFilter)) == NULL) // alloc reference IsoPhotalflux vector
    {
      printf("malloc error 1541 \n");
      if (flux) free(flux);
      return -1;
    }
  
  if ( (TssBuffer=(double*)malloc(sizeof(double)*NN)) == NULL) // alloc Tss buffer
    {
      printf("malloc error 1542 \n");
      if (flux) free(flux);
      if (fr) free(fr);
      return -1;
    }

  if ( (pcs=(double*)malloc(sizeof(double)*NN)) == NULL) //pointer to chi squared??
    {
      printf("malloc error 1543 \n");
      if (flux) free(flux);
      if (TssBuffer) free(TssBuffer);
      if (fr) free(fr);
      return -1;
    }

  if (*eta<0) // now performing fit of the Tss
    { 
      // fill in the Tss Buffer
      for (j=0; j<NN; j++)
	TssBuffer[j]=TssLow+TSS_STEP*j;
  
      if (mode & TM_MODE_VERBOSE)
	printf("neatm init>%lf\t%lf\t%lf\t%lf\n", H, pv, A, *R*2);
  
      //////////////////////////////////////////////////////////////////////
      //// FIRST LOOP TO FIND THE TSS with COARSE STEP 
      //////////////////////////////////////////////////////////////////////
      for (j=0; j<NN; j++) // loops over the Tss steps
	{
	  for (i=0; i<nFilter; i++) // loops over the data
	    { 
	      NEATMflux_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, 
			  TssBuffer[j], epsilon, *R, Delta, alfa, N);	  
	      fr[i]=ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
	      //printf("Victor: computeisoflux = %e\n",ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection));
	    }
      
	  // compute the appropriate Dsq-value that minimize the X^2
	  num=0; den=0;
	  for (i=0; i<nFilter; i++)	
	    {
	      num+=((f[i]*fr[i])/ef[i]/ef[i]); 
	      den+=((fr[i]*fr[i])/ef[i]/ef[i]);
	    }
	  Dsq=num/den;
	      
	  // compute the chisquare
	  chisq=0.0; for (i=0; i<nFilter; i++) chisq+=((f[i]-Dsq*fr[i])*(f[i]-Dsq*fr[i])/(ef[i]*ef[i]));
	  // store it
	  pcs[j]=chisq;
	    
	  if (mode & TM_MODE_VERBOSE)
	    printf("neatm> %d\t%d\t%lf\t%e\t%lf\t%lf\t%lf\n", j, 
		   nFilter, TssBuffer[j], pcs[j],*Pv, A,*R*2*sqrt(Dsq));
	  //we print 2Rsqrt(Dsq) but we do not save it. Why? 

	  // exit from min chisq search condition i.e. the new chi^2 > old chi^2
	  if ((j>2) && ((pcs[j-2]-pcs[j-1])>0) && ((pcs[j]-pcs[j-1])>0)) { i=j-1; break;}	
	}// end of the loop over the eta buffer

      if (j>=NN) // did not find a Min of the X2 it exit
	{
	  printf("Neatm did not find a MIN of the X2 within the Tss loop\n");
	  //	  exit(-1);
	}

      if (mode & TM_MODE_VERBOSE)
	printf("neatm best>%d<\t%lf\t%lf\n",i, TssBuffer[i], pcs[i]);
 
      /////////////////////////////////////////////////////////////
      //// FIND THE BEST TSS by using a parabola aournd the minimum 
      /////////////////////////////////////////////////////////////
      memcpy(&x, &TssBuffer[i-1], sizeof(double)*3);
      memcpy(&y, &pcs[i-1], sizeof(double)*3);
      x[1]-=x[0]; x[2]-=x[0];
      y[1]-=y[0]; y[2]-=y[0];
      b=(y[1]*x[2]*x[2] - x[1]*x[1]*y[2])/(x[1]*x[2]*x[2] - x[2]*x[1]*x[1]);
      a=(y[1] - b*x[1])/x[1]/x[1];
      *Tss=-b/2/a + x[0];
      //*R=*R*sqrt(Dsq);	// correct R
      //Victor: it is commented. Why?	

      if (mode & TM_MODE_VERBOSE)
	printf(">>>> Tss at min of parabola is %lf\n",*Tss);

      /////////////////////////////////////////////////////////////
      //// DO a PARABOLA BY OFFSETTING -5 +5 around the minimum
      ///////////////////////////////////////////////////////////
      TssBuffer[0]=*Tss-5; TssBuffer[1]=*Tss; TssBuffer[2]=*Tss+5;
      for (j=0; j<3; j++)
	{
	  for (i=0; i<nFilter; i++)
	    { 
	      NEATMflux_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, TssBuffer[j], epsilon, *R, Delta, alfa, N);
	      fr[i]=ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
	    }
      
	  // compute the appropriate Dsq-value that minimize the X^2
	  num=0; den=0;
	  for (i=0; i<nFilter; i++)	
	    {
	      num+=((f[i]*fr[i])/ef[i]/ef[i]);
	      den+=((fr[i]*fr[i])/ef[i]/ef[i]);
	    }
	  Dsq=num/den;
	      
	  // compute the chisquare
	  chisq=0.0; for (i=0; i<nFilter; i++) chisq+=((f[i]-Dsq*fr[i])*(f[i]-Dsq*fr[i])/(ef[i]*ef[i]));
	  // store it
	  pcs[j]=chisq;
	    
	  if (mode & TM_MODE_VERBOSE)
	    printf("neatm> %d\t%d\t%lf\t%lf\t%lf\t%lf\t%lf\n", j, nFilter, TssBuffer[j], pcs[j],*Pv, A,*R*2*sqrt(Dsq));
	  //Victor: we print 2Rsqrt(Dsq) but we do not save it?
	}

      ///////////////////////////////////////////////////  ///////
      //// FIND THE BEST TSS by using a parabola aournd the minimum 
      ////////////////////////////////////////////////////////////
      memcpy(&x, TssBuffer, sizeof(double)*3);
      memcpy(&y, pcs, sizeof(double)*3);
      x[1]-=x[0]; x[2]-=x[0];
      y[1]-=y[0]; y[2]-=y[0];
      b=(y[1]*x[2]*x[2] - x[1]*x[1]*y[2])/(x[1]*x[2]*x[2] - x[2]*x[1]*x[1]);
      a=(y[1] - b*x[1])/x[1]/x[1];
      *Tss=-b/2/a + x[0];
      *R=*R*sqrt(Dsq);	// correct R
    }  // has worked with variable eta and should have found the best fit value

  else    ////////////// FIXED eta FIT //////////////////////////////
    {
      for (j=0; j<3; j++)
	{
	  A=Pv2A(*Pv, G); // compute A given pV and G	  
	  *Tss=TSS(A, *eta, r, epsilon);  // compute the Tss
	  
	  for (i=0; i<nFilter; i++) // calculate the NEATM for each filter
	    { 
	      NEATMflux_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, *Tss, epsilon, *R, Delta, alfa, N);
	      fr[i]=ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
	    }
	  
	  // compute the appropriate Dsq-value that minimize the X^2
	  num=0; den=0;
	  for (i=0; i<nFilter; i++)	
	    {
	      num+=((f[i]*fr[i])/ef[i]/ef[i]);
	      den+=((fr[i]*fr[i])/ef[i]/ef[i]);
	    }
      
	  Dsq=num/den;
	  *R=*R*sqrt(Dsq);	// correct R
	  *Pv=H2Pv(H, *R*2);    // recalculate pV
	  
	  // compute the chisquare
	  chisq=0.0; for (i=0; i<nFilter; i++) chisq+=((f[i]-Dsq*fr[i])*(f[i]-Dsq*fr[i])/(ef[i]*ef[i]));
      
	  if (mode & TM_MODE_VERBOSE)
	    printf("FIXED eta %d>\t%lf\t%lf\t%lf\t%lf\n", j, *Pv, A,*R*2, chisq);
	}
    } ////////////// FIXED eta FIT //////////////////////////////

  //////////////////////////////////////////////////////////////////////////////////////
  //FINAL NEATM to get everything in place
  /////////////////////////////////////////////////////////////////////////////////////
  if (mode & TM_MODE_VERBOSE)
    printf("Tss=%lf Diam=%lf pV=%lf  and now doing a final adjustment\n",*Tss,*R*2,*Pv);
  
  for (i=0; i<nFilter; i++)
    { 
      NEATMflux_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, *Tss, epsilon, *R, Delta, alfa, N);
      fr[i]=ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
    }
      
  // compute the appropriate Dsq-value that minimize the X^2
  num=0; den=0;
  for (i=0; i<nFilter; i++)	
    {
      num+=((f[i]*fr[i])/ef[i]/ef[i]);
      den+=((fr[i]*fr[i])/ef[i]/ef[i]);
    }
  
  Dsq=num/den;
  *R=*R*sqrt(Dsq);	// correct R
  //Victor: why here??
  
  // compute the chisquare
  chisq=0.0; for (i=0; i<nFilter; i++) chisq+=((f[i]-Dsq*fr[i])*(f[i]-Dsq*fr[i])/(ef[i]*ef[i]));
      
  if (mode & TM_MODE_VERBOSE)
    printf("%d>\t%lf\t%lf\t%lf\t%lf\n", j, *Pv, A,*R*2, chisq);
    	
  // compute the chisquare
  *pChisq=chisq;
  
  *Pv=H2Pv(H, *R*2);
  A=Pv2A(*Pv, G);
  *eta = (1-A)*SOLARC/r/r/Tss[0]/Tss[0]/Tss[0]/Tss[0]/SIGMA/epsilon;
  
  free(pcs);
  free(fr);
  free(TssBuffer);
  if (flux) free(flux);
}


///////////////////////////////////////////////////////////////////////
// fit the NEATM and the vtoband ratio to WISE IsoPhotal fluxes//
//////////////////////////////////////////////////////////////////////
//
// Marco Delbo Victor Ali
//
int NEATMandV2IRFitWISE(FILTER *Filter,	// list of available filters 
		     int    *FiltIndex, // zero based fiter indes
		     double *IsoFlux,	// Observed Isophotal Flux vector
		     double *eIsoFlux,	// error on flux vector
		     int    nData  ,    // number of elements in the filter index vector
		     double *ModelIsoFlux, // output of the model flux at best values of the parameters
		     double *R,		// Radius of the asteroid in km (1.fit param)
		     double *eR,	// Error on Diameter
		     double *pV,	// Geometric Albedo
		     double *epV,	// error on Pv
		     double *eta,	// eta value
		     double *eeta,	// error on eta value
		     double epsilon,    // emissivity
		     double r,	       	// distance from the sun
		     double Delta,	// distance from the earth
		     double alfa,	// phase angle
		     double H,	       	// H value
		     double G,		// G value
		     double *pChisq,    // Chi squared value of the fit
		     double *Tss,       // subsolar temperature
		     double *V2Ir,      // vtoir band ratio fitted in this procedure
		     int    N,	       	// number of iterations
		     int    mode)	// mode e.g Verbose
{
  int     FitEta=1; // tells the fitting routine to FitEta
  int	  NN=(int)((V2IR_MAX-V2IR_MIN)/V2IR_STEP) + 1;
  double  *V2IRBuffer=NULL,*pcs=NULL;
  double  chisq=0.0;
  double  Dsq, Dsqbest, DsqDen;
  int	  i,j,k;
  double  num, den;
  double  a, b, x[3], y[3];
  double  *flux=NULL, *fr=NULL, *PureThermalIsoFlux=NULL; // fluxbuffer for filter calculation
  double  *colorcorrection=NULL;
	

  if (*eta>0) FitEta=0; // if input eta is valid, do not fit it at each step

  if (N > 10000) {printf("More than 10000 iterations??? \n qutting\n"); return -1;}
  if (nData<=0) {printf("No data?? quitting\n"); return -1; }
  
  if ( (flux=(double*)malloc(sizeof(double)*5000)) == NULL) // alloc reference monocromatic flux vector for the NEATM output
    {
      printf("malloc error 1540 \n");
      return -1;
    }
  
  if ( (fr=(double*)malloc(sizeof(double)*nData)) == NULL) // alloc reference IsoPhotalflux vector
    {
      printf("malloc error 1541 \n");
      if (flux) free(flux);
      return -1;
    }

  if ( (PureThermalIsoFlux=(double*)malloc(sizeof(double)*nData)) == NULL) // alloc reference IsoPhotalflux vector
    {
      printf("malloc error 1541 \n");
      if (flux) free(flux);
      if (fr) free(fr);
      return -1;
    }
  
  if ( (V2IRBuffer=(double*)malloc(sizeof(double)*NN)) == NULL) // alloc V2IRBuffer buffer
    {
      printf("malloc error 1542 \n");
      if (flux) free(flux);
      if (PureThermalIsoFlux) free(PureThermalIsoFlux);
      if (fr) free(fr);
      return -1;
    }

  if ( (pcs=(double*)malloc(sizeof(double)*NN)) == NULL) //
    {
      printf("malloc error 1543 \n");
      if (flux) free(flux);
      if (V2IRBuffer) free(V2IRBuffer);
      if (PureThermalIsoFlux) free(PureThermalIsoFlux);
      if (fr) free(fr);
      return -1;
    }

  // fill in the Tss V2IRBuffer
  for (j=0; j<NN; j++)
    V2IRBuffer[j]=V2IR_MIN+V2IR_STEP*j;


  if (*V2Ir<0) // if the value of this parameter is negative, the code perform a fit.
    {
      //////////////////////////////////////////////////////////////////////
      //// FIRST LOOP TO FIND THE TSS with COARSE STEP 
      //////////////////////////////////////////////////////////////////////
      for (j=0; j<NN; j++) // loops over the V2IRBuffer steps
	{
	  printf("Step %d; V2IRBuffer[%d]= %e\n",j,j,V2IRBuffer[j]);
       	  /////////////////////////////////////////////////////
	  // remove the reflected light component
	  ////////////////////////////////////////////////////
	  for (i=0; i<nData; i++)
	    { 
	      memset(flux,0,Filter[FiltIndex[i]].nlambda*sizeof(double)); // set flux to zero
	      // TBD: vto 3.6 um ratio is used here and not 3.35 that should be used for WISE
	      if (V2IRBuffer[j]>0)
		{ 
		  AddReflComp_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, H, G, r, Delta, alfa, V2IRBuffer[j]);
		  //		  printf("Filter[filtIndex[%d]].nlambda =%d\n",i,Filter[FiltIndex[i]].nlambda);
		  printf("Loaded the reflcomp to flux \n");
		}
	      else
		{
		  printf("Did not add the reflcomp to flux\n");
		}
	      PureThermalIsoFlux[i]=IsoFlux[i]-ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
	      //Victor
	      printf("band %d, purethermalisoflux = %e, isoflux = %e, computeisoflux = %e\n", 
		     i,PureThermalIsoFlux[i],IsoFlux[i],ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection)); 
	      //removal took place
	    }
	  
	  *R=H2DIAM(H, *pV)/2; // guess radius
	  
	  if (FitEta) *eta=-1; // set it to negative value to get it fitted
	  NEATMFitWISE(Filter, FiltIndex, PureThermalIsoFlux, eIsoFlux, nData, R, eR, pV, epV,
		       H, eta, eeta, epsilon,
		       Delta, r, alfa,
		       G, &chisq, Tss, N, mode);
	  
	  for (i=0; i<nData; i++)
	    { 
	      NEATMflux_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, *Tss, epsilon, *R, Delta, alfa, N);
	  
	      // TBD: vto 3.6 um ratio is used here and not 3.35 that should be used for WISE
	      if (V2IRBuffer[j]>0) 
		AddReflComp_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, H, G, r, Delta, alfa, V2IRBuffer[j]);
	      
	      fr[i]=ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
	    }
	  
	  // compute the chisquare
	  chisq=0.0; 
	  for (i=0; i<nData; i++) 
	    chisq+=((IsoFlux[i]-fr[i])*(IsoFlux[i]-fr[i])/(eIsoFlux[i]*eIsoFlux[i]));
	  // store it
	  pcs[j]=chisq;

	  if (mode & TM_MODE_VERBOSE)
	    printf("V2IRt>%d\t%lf\t%lf\t%lf\t%lf\n",i, *R*2, *pV, V2IRBuffer[j], pcs[j]);
	  
	  // exit from min chisq search condition
	  if ((j>2) && ((pcs[j-2]-pcs[j-1])>0) && ((pcs[j]-pcs[j-1])>0)) { i=j-1; break;}	
	}
      

      if (mode & TM_MODE_VERBOSE)
	printf("V2IR best>%d<\t%lf\t%lf\n",i, V2IRBuffer[i], pcs[i]);
      
      ///////
      //// FIND THE BEST TSS by using a parabola around the minimum 
      ///////
      memcpy(&x, &V2IRBuffer[i-1], sizeof(double)*3);
      memcpy(&y, &pcs[i-1], sizeof(double)*3);
      x[1]-=x[0]; x[2]-=x[0];
      y[1]-=y[0]; y[2]-=y[0];
      b=(y[1]*x[2]*x[2] - x[1]*x[1]*y[2])/(x[1]*x[2]*x[2] - x[2]*x[1]*x[1]);
      a=(y[1] - b*x[1])/x[1]/x[1];
      *V2Ir=-b/2/a + x[0];
      //  *R=*R*sqrt(Dsq);	// correct R
      if (mode & TM_MODE_VERBOSE)
	printf(">>>> V2Ir at min of parabola is %lf\n",*V2Ir);
    }
  else // if the value of the V2Ir is positve then it is used with no FIT
    {
      *V2Ir=fabs(*V2Ir);
      //Victor: if it is positive, why do we fabs()?
    } //is this } meant to be here??

  //////////////////////////////////////
  ///// perform a final fit at best V2Ir
  /////////////////////////////////////
  for (i=0; i<nData; i++)
    { 
      memset(flux,0,Filter[FiltIndex[i]].nlambda*sizeof(double)); // set flux to zero
       if (*V2Ir>0) 
	AddReflComp_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, H, G, r, Delta, alfa, *V2Ir);
      PureThermalIsoFlux[i]=IsoFlux[i]-ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
    }

  if (FitEta) *eta=-1; // set it to negative value to get it fitted
  NEATMFitWISE(Filter, FiltIndex, PureThermalIsoFlux, eIsoFlux, nData, R, eR, pV, epV,
	       H, eta, eeta, epsilon,
	       Delta, r, alfa,
	       G, &chisq, Tss, N, mode);
  
  for (i=0; i<nData; i++)
    { 
      NEATMflux_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, *Tss, epsilon, *R, Delta, alfa, N);
      
      // TBD: vto 3.6 um ratio is used here and not 3.35 that should be used for WISE
      if (*V2Ir>0) 
	AddReflComp_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, H, G, r, Delta, alfa, *V2Ir);
	  
      fr[i]=ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
    }

  // compute the chisquare
  chisq=0.0; 
  for (i=0; i<nData; i++) 
    chisq+=((IsoFlux[i]-fr[i])*(IsoFlux[i]-fr[i])/(eIsoFlux[i]*eIsoFlux[i]));
  
  memcpy(ModelIsoFlux, fr, nData*sizeof(double));
  *pChisq=chisq;

  free(pcs);
  free(fr);
  free(V2IRBuffer);
  if (flux) free(flux);
  if (PureThermalIsoFlux) free(PureThermalIsoFlux);
 }

main(int argc, char* argv[])
{
  FILTER filter[4];
  double averageflux[4],
    IsoFluxVega[4]={8.180e-11, 2.415e-11, 6.515e-13, 5.090e-14},  // IsoPhotalFlux of Vega in W/m^2/um
    zeropoint[4]={35.218, 36.543, 40.465, 43.233}; // TBD : apply the iso flux offsets for VEGA! 
    double        r=1, Delta=1, pha=0;
    double	R=1, // radius of the asteroid 
      pV=0.15, // guess value of the pV 
      G=0.15,
      eta=-1.0, //The value of the beaming parameter
                // If it is negative the the code perform a fit of this parameter
      epsilon=0.9,
      vtobandratio=-1.0, // The value of the V to Ir ratio. 
                // If it is negative then the code perform a fit of this parameter
      A=0.0,
      H=0,
      epV, eR, eeta, chisq;

    int mode=0;

    int         FiltIndex[NMAX];
    double	isoflux[NMAX]; // IsoFlux vector
    double      ModelFlux[NMAX]; // Model flux
    double      PureThermalIsoFlux[NMAX];
    double      sigmaisoflux[NMAX]; // Magnitude uncertainity vector
    double      filterid[NMAX]; // list of filter vector 
    int		Ndata=0; // Number of data points
    char          ias[4];
    double	Tss;
    int		i,k;
    char*	        filename=NULL;
    double      flux[5000];
    double      fr[NMAX];
    
    double colorcorrection[4];
    char   filtname[4][30]={"w1.interpolated.txt","w2.interpolated.txt","w3.interpolated.txt","w4.interpolated.txt"};
    int ifilt;

    char name[50];
    
  while (argc>1)
    {
      if (argv[1][0]=='-')
	{
	  switch (argv[1][1])
	    {
	    case 'e':// change the emissivity
	      argc--; argv++; epsilon=atof(argv[1]);
	      break;
	    case 'G'://to change the G
	      argc--; argv++; G=atof(argv[1]);
	      break;
	    case 'p':// change the initial pV
	      argc--; argv++; pV=atof(argv[1]);
	      break;
	    case 'b'://to change the beaming parameter initial value
	      argc--; argv++; eta=atof(argv[1]);
	      break;
	    case 'V':// change the vto band ratio value
	      argc--; argv++; 
	      vtobandratio=atof(argv[1]);
	      break;
	    case 'i':// select parameter to fit e.g. 111 fit all paprameter 100 fit only D 
	      argc--; argv++; 
	      strcpy(ias,argv[1]);
	      break;  
	    case 'h': // show the help
	      printf("%s\n",USAGE);
	      printf("%s\n",ADARGS);
	      return 0;
	      break;
	    case 'v':
	      mode+=TM_MODE_VERBOSE;
	      break;
	    default:
	      printf("unknown option -%c\n",argv[1][1]);
	      return 0;
	      break;
	    }
	} 
      argc--;
      argv++;
    }


  // load the filters
  for(ifilt=0; ifilt<4; ifilt++)
    LoadFilter(&filter[ifilt], filtname[ifilt],mode); 

  // DEBUG print a filter
  //  for (i=0; i<w[1].nlambda; i++) printf("%lf %lf %lf\n",w[1].lambda[i],w[1].response[i],w[1].dlambda[i]);

  scanf("%s %lf %lf %lf %lf", name, &H, &r, &Delta, &pha); // read the input
  // get data
  Ndata=0;
  while (scanf("%d %lf %lf", &FiltIndex[Ndata], &isoflux[Ndata], &sigmaisoflux[Ndata])==3) // loads magnitudes
    {
      Ndata++;
    }

  if (mode & TM_MODE_VERBOSE)
    {
      printf("of data=%d\n", Ndata);
      printf("filt id\t\tmag\t\tmagunc\n");
      for (i=0; i<Ndata; i++)
	printf("%d\t%lf\t%lf\n", FiltIndex[i], isoflux[i], sigmaisoflux[i]); // print loaded data (mags)
    }

  for (i=0; i<Ndata; i++)
    {
      FiltIndex[i]--; // zero based index
      isoflux[i]=pow(10,-isoflux[i]*0.4)*IsoFluxVega[FiltIndex[i]];
      sigmaisoflux[i]=isoflux[i]*0.92103404*sigmaisoflux[i];
    }

  if (mode & TM_MODE_VERBOSE)
    {
      printf("of data=%d\n", Ndata);
      printf("filt id\t\tIsoFlux\tFluxUncert\n");
      for (i=0; i<Ndata; i++)
	printf("%d\t%e\t%e\n", FiltIndex[i], isoflux[i], sigmaisoflux[i]); // print loaded data (mags)
    }

  // TBD put here the call to the new routine

  NEATMandV2IRFitWISE(filter,	// list of available filters 
		      FiltIndex, // zero based fiter indes
		      isoflux,	// Observed Isophotal Flux vector
		      sigmaisoflux,	// error on flux vector
		      Ndata,    // number of elements in the filter index vector
		      ModelFlux,
		      &R,		// Radius of the asteroid in km (1.fit param)
		      &eR,	// Error on Diameter
		      &pV,	// Geometric Albedo
		      &epV,	// error on Pv
		      &eta,	// eta value
		      &eeta,	// error on eta value
		      epsilon,    // emissivity
		      r,	       	// distance from the sun
		      Delta,	// distance from the earth
		      pha,	// phase angle
		      H,	       	// H value
		      G,		// G value
		      &chisq,    // Chi squared value of the fit
		      &Tss,       // subsolar temperature
		      &vtobandratio,      // vtoir band ratio fitted in this procedure
		      NITER,	       	// number of iterations
		      mode);	// mode e.g Verbose


  printf("wise-h> %20s\tD(km)\t\t pV\t\t eta\t\t Tss\t\t VtoBandRatio\t\t chi^2\n","Name");
  printf("wise-r> %20s\t%lf\t %lf\t %lf\t %lf\t %lf\t\t %lf\n", name, R*2, pV, eta, Tss, vtobandratio, chisq);
 
  printf("wise-h> Band\tModel\t\tIsoFLuxObserved\tError\n");
  for (i=0; i<Ndata; i++)
    printf("wise-f> %d\t%e\t%e\t%e\n", FiltIndex[i]+1, ModelFlux[i], isoflux[i], sigmaisoflux[i]);

}
#undef NRANSI
