/*
This is to FIT a NEATM to WISE magnitudes
M. Delbo, V. Ali Aug 2011: Tenerife
last update Aug 30, Tenerife
 */
#define NRANSI
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "../tms/tm.h"
#include "../tms/constants.h"
#include "../tms/macros.h"
#include "filter.h"

#define	 NITER		250
#define  NMAX           1000
#define  MA             3
#define	 TSS_RANGE      0.3
#define	 TSS_STEP       10

#define USAGE "\n"
#define ADARGS "-l <lambda0> <lambda1> <lambdastep> to change the default wavelenght range\n\
 -m mode 0=NEATM 2=STM 3=FRM\n\
 -e <emissivity value>\n\
 -g <G_value>\n\
 -o <output_filename>\n\
 -r column mode\n\
 -b <beta_e> \n\
 -v verbose mode\n\
 -V <VtoBandsRatio>\n"

#define PROG     "FitTM"
#define AUTHOR   "Marco Delbo"
#define VERSION  "beta 1.0"
#define REL_DATE "January 10, 2008"


///////////////////////////////////////////////////////////////////////
// fit the Near Earth Asteroid Thermal Model to WISE IsoPhotal fluxes//
//////////////////////////////////////////////////////////////////////
//
// Marco Delbo Victor Ali
//
int NEATMFitWISE(FILTER *Filter,	// list of available filters 
		 int    *FiltIndex,     // zero based fiter indes
		 double *f,		// flux vector
		 double *ef,		// error on flux vector
		 int    nFilter,       	// number of elements in the filter index vector
		 double *R,		// Radius of the asteroid in km (1.fit param)
		 double *eR,		// Error on Diameter
		 double *Pv,		// Geometric Albedo
		 double *ePv,		// error on Pv
		 double H,	       	// H value
		 double *eta,		// eta value
		 double *eeta,		// error on eta value
		 double epsilon,       	// emissivity
		 double Delta,		// distance from the earth
		 double r,	       	// distance from the sun
		 double alfa,		// phase angle
		 double G,		// G value
		 double *pChisq,       	// Chi squared value of the fit
		 double *Tss,           // subsolar temperature
		 int    N,	       	// number of iterations
		 int    mode)		// mode e.g Verbose
{
  double  pv=*Pv;		       	// use the user-provided guess albedo.
  double  A=Pv2A(*Pv, G);		// derive the Bolometric Bond's Albedo; 
          *Tss=TSS(A, 1, r, epsilon);    // initial Tss
  double  TssLow = floor(Tss[0]*(1-TSS_RANGE)),
    TssHi=ceil(Tss[0]*(1+TSS_RANGE));
  int	  NN=(int)((TssHi-TssLow)/TSS_STEP) + 1;
  double  *TssBuffer,*pcs=NULL;
  double  *fr=NULL;
  double  beginchisq, bestchisq, chisq=0.0;
  double  Dsq, Dsqbest, DsqDen;
  int	  i,j,k;
  double  num, den;
  double  a, b, x[3], y[3];
  double  *flux; // fluxbuffer for filter calculation
  double  *colorcorrection;
	
  if (mode & TM_MODE_VERBOSE) printf("Entering NEATMfit for WISE with guess TSS=%lf\n", *Tss);
  /*
  if (mode & TM_MODE_VERBOSE) 
    {
      printf("There are %d filters in this dataset\n", nFilter);
      for(j=0; j<nFilter; j++)
	{
	  printf("Filter %d in the set, which is W%d\n", j, FiltIndex[j]+1);
	  for(i=0; i<Filter[FiltIndex[j]].nlambda; i++)
	    printf(" %lf",Filter[FiltIndex[j]].lambda[i]);
	  printf("\n");
	}
    }
  */
  
  if (N > 10000) {printf("More than 10000 iterations??? \n qutting\n"); return -1;}
  if (nFilter<=0) {printf("No data?? quitting\n"); return -1; }
  if (pv<=0) pv=0.01;//reset pV to low albedo object 
  
  if ( (flux=(double*)malloc(sizeof(double)*5000)) == NULL) // alloc reference monocromatic flux vector for the NEATM output
    {
      printf("malloc error 1540 \n");
      return -1;
    }
  
  if ( (fr=(double*)malloc(sizeof(double)*nFilter)) == NULL) // alloc reference IsoPhotalflux vector
    {
      printf("malloc error 1541 \n");
      if (flux) free(flux);
      return -1;
    }
  
  if ( (TssBuffer=(double*)malloc(sizeof(double)*NN)) == NULL) // alloc eta buffer
    {
      printf("malloc error 1542 \n");
      if (flux) free(flux);
      if (fr) free(fr);
      return -1;
    }

  if ( (pcs=(double*)malloc(sizeof(double)*NN)) == NULL) //
    {
      printf("malloc error 1543 \n");
      if (flux) free(flux);
      if (TssBuffer) free(TssBuffer);
      if (fr) free(fr);
      return -1;
    }

  // fill in the Tss Buffer
  for (j=0; j<NN; j++)
    TssBuffer[j]=TssLow+TSS_STEP*j;
  
  if (mode & TM_MODE_VERBOSE)
    printf("neatm init>%lf\t%lf\t%lf\t%lf\n", H, pv, A, *R*2);
  
  *R=H2DIAM(H, *Pv)/2.0;		// calculate the diameter from the H value and pv

  //////////////////////////////////////////////////////////////////////
  //// FIRST LOOP TO FIND THE TSS with COARSE STEP 
  //////////////////////////////////////////////////////////////////////
  for (j=0; j<NN; j++) // loops over the Tss steps
    {
      for (i=0; i<nFilter; i++) // loops over the data
	{ 
	  NEATMflux_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, TssBuffer[j], epsilon, *R, Delta, alfa, N);	  
	  fr[i]=ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
	}
      
      // compute the appropriate Dsq-value that minimize the X^2
      num=0; den=0;
      for (i=0; i<nFilter; i++)	
	{
	  num+=((f[i]*fr[i])/ef[i]/ef[i]);
	  den+=((fr[i]*fr[i])/ef[i]/ef[i]);
	}
      Dsq=num/den;
	      
      // compute the chisquare
      chisq=0.0; for (i=0; i<nFilter; i++) chisq+=((f[i]-Dsq*fr[i])*(f[i]-Dsq*fr[i])/(ef[i]*ef[i]));
      // store it
      pcs[j]=chisq;
	    
      if (mode & TM_MODE_VERBOSE)
	printf("neatm> %d\t%d\t%lf\t%lf\t%lf\t%lf\t%lf\n", j, nFilter, TssBuffer[j], pcs[j],*Pv, A,*R*2*sqrt(Dsq));
 
      // exit from min chisq search condition
      if ((j>2) && ((pcs[j-2]-pcs[j-1])>0) && ((pcs[j]-pcs[j-1])>0)) { i=j-1; break;}	
    }

  if (mode & TM_MODE_VERBOSE)
    printf("neatm best>%d<\t%lf\t%lf\n",i, TssBuffer[i], pcs[i]);
 
  ///////
  //// FIND THE BEST TSS by using a parabola aournd the minimum 
  ///////
  memcpy(&x, &TssBuffer[i-1], sizeof(double)*3);
  memcpy(&y, &pcs[i-1], sizeof(double)*3);
  x[1]-=x[0]; x[2]-=x[0];
  y[1]-=y[0]; y[2]-=y[0];
  b=(y[1]*x[2]*x[2] - x[1]*x[1]*y[2])/(x[1]*x[2]*x[2] - x[2]*x[1]*x[1]);
  a=(y[1] - b*x[1])/x[1]/x[1];
  *Tss=-b/2/a + x[0];
  //  *R=*R*sqrt(Dsq);	// correct R
  if (mode & TM_MODE_VERBOSE)
    printf(">>>> Tss at min of parabola is %lf\n",*Tss);

  ///////
  //// DO a PARABOLA BY OFFSETTING -5 +5 around the minimum
  ///////
  TssBuffer[0]=*Tss-5; TssBuffer[1]=*Tss; TssBuffer[2]=*Tss+5;
  for (j=0; j<3; j++)
    {
      for (i=0; i<nFilter; i++)
	{ 
	  NEATMflux_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, TssBuffer[j], epsilon, *R, Delta, alfa, N);
	  fr[i]=ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
	}
      
      // compute the appropriate Dsq-value that minimize the X^2
      num=0; den=0;
      for (i=0; i<nFilter; i++)	
	{
	  num+=((f[i]*fr[i])/ef[i]/ef[i]);
	  den+=((fr[i]*fr[i])/ef[i]/ef[i]);
	}
      Dsq=num/den;
	      
      // compute the chisquare
      chisq=0.0; for (i=0; i<nFilter; i++) chisq+=((f[i]-Dsq*fr[i])*(f[i]-Dsq*fr[i])/(ef[i]*ef[i]));
      // store it
      pcs[j]=chisq;
	    
      if (mode & TM_MODE_VERBOSE)
	printf("neatm> %d\t%d\t%lf\t%lf\t%lf\t%lf\t%lf\n", j, nFilter, TssBuffer[j], pcs[j],*Pv, A,*R*2*sqrt(Dsq));
     }

  ///////////////////////////////////////////////////  ///////
  //// FIND THE BEST TSS by using a parabola aournd the minimum 
  ////////////////////////////////////////////////////////////
  memcpy(&x, TssBuffer, sizeof(double)*3);
  memcpy(&y, pcs, sizeof(double)*3);
  x[1]-=x[0]; x[2]-=x[0];
  y[1]-=y[0]; y[2]-=y[0];
  b=(y[1]*x[2]*x[2] - x[1]*x[1]*y[2])/(x[1]*x[2]*x[2] - x[2]*x[1]*x[1]);
  a=(y[1] - b*x[1])/x[1]/x[1];
  *Tss=-b/2/a + x[0];
   *R=*R*sqrt(Dsq);	// correct R
  

  if (mode & TM_MODE_VERBOSE)
    printf("Tss=%lf Diam=%lf pV=%lf  and now doing final adjustment\n",*Tss,*R*2,*Pv);
 
     for (i=0; i<nFilter; i++)
	{ 
	  NEATMflux_W(Filter[FiltIndex[i]].lambda, flux, Filter[FiltIndex[i]].nlambda, *Tss, epsilon, *R, Delta, alfa, N);
	  fr[i]=ComputeIsoFlux(flux,&Filter[FiltIndex[i]],0,colorcorrection);
	}
      
      // compute the appropriate Dsq-value that minimize the X^2
      num=0; den=0;
      for (i=0; i<nFilter; i++)	
	{
	  num+=((f[i]*fr[i])/ef[i]/ef[i]);
	  den+=((fr[i]*fr[i])/ef[i]/ef[i]);
	}
      
      Dsq=num/den;
      *R=*R*sqrt(Dsq);	// correct R
		
      // compute the chisquare
      chisq=0.0; for (i=0; i<nFilter; i++) chisq+=((f[i]-Dsq*fr[i])*(f[i]-Dsq*fr[i])/(ef[i]*ef[i]));
      
      if (mode & TM_MODE_VERBOSE)
	printf("%d>\t%lf\t%lf\t%lf\t%lf\n", j, *Pv, A,*R*2, chisq);
    	

  // compute the chisquare
  *pChisq=chisq;

  *Pv=H2Pv(H, *R*2);
  A=Pv2A(*Pv, G);
  *eta = (1-A)*SOLARC/r/r/Tss[0]/Tss[0]/Tss[0]/Tss[0]/SIGMA/epsilon;

  free(pcs);
  free(fr);
  free(TssBuffer);
  if (flux) free(flux);
}


main(int argc, char* argv[])
{
  FILTER filter[4];
  double averageflux[4],
    IsoFluxVega[4]={8.180e-11, 2.415e-11, 6.515e-13, 5.090e-14},  // IsoPhotalFlux of Vega in W/m^2/um
    zeropoint[4]={35.218, 36.543, 40.465, 43.233}; // TBD : apply the mag offsets for VEGA! 
    double        r=1, Delta=1, pha=0;
    double	R=1, // radius of the asteroid 
      pV=0.15, // guess value of the pV 
      G=0.15,
      eta=1.0, // guess value of the eta
      epsilon=0.9,
      vtobandratio=1.4, // guess valut of the vto3micronratio  TBD: it's 3.3526 
      A=0.0,
      H=0,
      epV, eR, eeta, chisq;

    int mode=0;

    int         FiltIndex[NMAX];
    double	isoflux[NMAX]; // IsoFlux vector
    double      PureThermalIsoFlux[NMAX];
    double      sigmaisoflux[NMAX]; // Magnitude uncertainity vector
    double      filterid[NMAX]; // list of filter vector 
    int		Ndata=0; // Number of data points
    char          ias[4];
    double	Tss;
    int		i,k;
    char*	        filename=NULL;
    double      flux[5000];
    double      fr[NMAX];
    
    double colorcorrection[4];
    char   filtname[4][30]={"w1.interpolated.txt","w2.interpolated.txt","w3.interpolated.txt","w4.interpolated.txt"};
    int ifilt;
    
  while (argc>1)
    {
      if (argv[1][0]=='-')
	{
	  switch (argv[1][1])
	    {
	    case 'e':// change the emissivity
	      argc--; argv++; epsilon=atof(argv[1]);
	      break;
	    case 'G'://to change the G
	      argc--; argv++; G=atof(argv[1]);
	      break;
	    case 'p':// change the initial pV
	      argc--; argv++; pV=atof(argv[1]);
	      break;
	    case 'b'://to change the beaming parameter initial value
	      argc--; argv++; eta=atof(argv[1]);
	      break;
	    case 'V':// change the vto band ratio value
	      argc--; argv++; 
	      vtobandratio=atof(argv[1]);
	      break;
	    case 'i':// select parameter to fit e.g. 111 fit all paprameter 100 fit only D 
	      argc--; argv++; 
	      strcpy(ias,argv[1]);
	      break;  
	    case 'h': // show the help
	      printf("%s\n",USAGE);
	      printf("%s\n",ADARGS);
	      return 0;
	      break; 
	    case 'v':
	      mode+=TM_MODE_VERBOSE;
	      break;
	    default:
	      printf("unknown option -%c\n",argv[1][1]);
	      return 0;
	      break;
	    }
	} 
      argc--;
      argv++;
    }


  // load the filters
  for(ifilt=0; ifilt<4; ifilt++)
    LoadFilter(&filter[ifilt], filtname[ifilt],mode); 

  // DEBUG print a filter
  //  for (i=0; i<w[1].nlambda; i++) printf("%lf %lf %lf\n",w[1].lambda[i],w[1].response[i],w[1].dlambda[i]);

  scanf("%lf %lf %lf %lf", &H, &r, &Delta, &pha); // read the input
  // get data
  Ndata=0;
  while (scanf("%d %lf %lf", &FiltIndex[Ndata], &isoflux[Ndata], &sigmaisoflux[Ndata])==3) // loads magnitudes
    {
      Ndata++;
    }

  if (mode & TM_MODE_VERBOSE)
    {
      printf("of data=%d\n", Ndata);
      printf("filt id\t\tmag\t\tmagunc\n");
      for (i=0; i<Ndata; i++)
	printf("%d\t%lf\t%lf\n", FiltIndex[i], isoflux[i], sigmaisoflux[i]); // print loaded data (mags)
    }

  for (i=0; i<Ndata; i++)
    {
      FiltIndex[i]--; // zero based index 
      isoflux[i]=pow(10,-isoflux[i]*0.4)*IsoFluxVega[FiltIndex[i]];
      sigmaisoflux[i]=isoflux[i]*0.92103404*sigmaisoflux[i];
      
      //      printf("%d\t%e\t%e\n",FiltIndex[i], isoflux[i], sigmaisoflux[i]);
    }

  /////////////////////////////////////////////////////
  // remove the reflected light component
  ////////////////////////////////////////////////////
  for (i=0; i<Ndata; i++)
    { 
      memset(flux,0,filter[FiltIndex[i]].nlambda*sizeof(double)); // set flux to zero
      // TBD: vto 3.6 um ratio is used here and not 3.35 that should be used for WISE
      if (vtobandratio>0) 
	AddReflComp_W(filter[FiltIndex[i]].lambda, flux, filter[FiltIndex[i]].nlambda, H, G, r, Delta, pha, vtobandratio);
      PureThermalIsoFlux[i]=isoflux[i]-ComputeIsoFlux(flux,&filter[FiltIndex[i]],0,colorcorrection);
    }

  R=H2DIAM(H, pV)/2; // guess radius
	
  NEATMFitWISE(filter, FiltIndex, PureThermalIsoFlux, sigmaisoflux, Ndata, &R, &eR, &pV, &epV,
	       H, &eta, &eeta, epsilon,
	       Delta, r, pha,
	       G, &chisq, &Tss, NITER, mode);

  
  printf("Band\tModel\t\tIsoFLuxObserved\tError\n", FiltIndex[i]+1, fr[i], isoflux[i]);
  for (i=0; i<Ndata; i++)
    { 
      NEATMflux_W(filter[FiltIndex[i]].lambda, flux, filter[FiltIndex[i]].nlambda, Tss, epsilon, R, Delta, pha, NITER);
      
      // TBD: vto 3.6 um ratio is used here and not 3.35 that should be used for WISE
      if (vtobandratio>0) 
	AddReflComp_W(filter[FiltIndex[i]].lambda, flux, filter[FiltIndex[i]].nlambda, H, G, r, Delta, pha, vtobandratio);

      fr[i]=ComputeIsoFlux(flux,&filter[FiltIndex[i]],0,colorcorrection);
      printf("W%d\t%e\t%e\t%e\n", FiltIndex[i]+1, fr[i], isoflux[i], sigmaisoflux[i]);
    }
  // compute the chisquare
  chisq=0.0; 
  for (i=0; i<Ndata; i++) 
    chisq+=((isoflux[i]-fr[i])*(isoflux[i]-fr[i])/(sigmaisoflux[i]*sigmaisoflux[i]));

  printf("neatm-h> D(km)\t\t pV\t\t eta\t\t Tss\t\t VtoBandRatio\t\t chi^2\n");
  printf("neatm-r> %lf\t %lf\t %lf\t %lf\t %lf\t\t %lf\n", R*2, pV, eta, Tss, vtobandratio, chisq);
 

}
#undef NRANSI
