/*
This is to FIT a NEATM to WISE magnitudes
M. Delbo, V. Ali Aug 2011: Tenerife
last update Aug 30, Tenerife
 */
#define NRANSI
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "../tms/tm.h"
#include "../tms/constants.h"
#include "../tms/macros.h"
#include "filter.h"
//#include "../nr/nr.h"
#include "../nr/nrutil.h"

#define	 NITER		250
#define  NMAX           1000
#define  MA             3


#define USAGE "\n"
#define ADARGS "-l <lambda0> <lambda1> <lambdastep> to change the default wavelenght range\n\
 -m mode 0=NEATM 2=STM 3=FRM\n\
 -e <emissivity value>\n\
 -g <G_value>\n\
 -o <output_filename>\n\
 -r column mode\n\
 -b <beta_e> \n\
 -v verbose mode\n\
 -V <VtoBandsRatio>\n"

#define PROG     "FitTM"
#define AUTHOR   "Marco Delbo"
#define VERSION  "beta 1.0"
#define REL_DATE "January 10, 2008"

FILTER filter[4];
double averageflux[4],
  IsoFluxVega[4]={8.180e-11, 2.415e-11, 6.515e-13, 5.090e-14},  // IsoPhotalFlux of Vega in W/m^2/um
    zeropoint[4]={35.218, 36.543, 40.465, 43.233}; // TBD : apply the mag offsets for VEGA! 
double        r=1, Delta=1, pha=0;
double	D=1, 
  pV=0.15, // guess value of the pV 
  G=0.15,
  eta=1.0, // guess value of the eta
  epsilon=0.9,
  vtobandratio=1.4, // guess valut of the vto3micronratio  TBD: it's 3.3526 
  A=0.0,
  H=0;

double flux[5000];

int verbose=0;

void mrqcof(double x[], double y[], double sig[], int ndata, double a[],
	int ia[], int ma, double **alpha, double beta[], double *chisq,
	void (*funcs)(double, double [], double *, double [], int));
void mrqmin(double x[], double y[], double sig[], int ndata, double a[],
	int ia[], int ma, double **covar, double **alpha, double *chisq,
	void (*funcs)(double, double [], double *, double [], int), double *alamda);

	       
void fwiseisoflux(double filtid, // filter id
	     double a[], // D eta vtobandratio
	     double *isoflux, // mags
	     double dyda[], // derivative of the magnitude with respect to the parameter
	     int na)// number of parameters
{
  int ifilt=(int)filtid-1,i;
  double Tss;
  double colorcorrection;
  
  D=a[1];
  //  if (D<0) D=0.01;
  eta=a[2];
  vtobandratio=a[3];
  pV=H2Pv(H, D);
  //  if (pV<0.01) {pV=0.01; D=H2DIAM(H, pV);}
  //  if (pV>2.0) {pV=2.0; D=H2DIAM(H, pV);}
  A=Pv2A(pV, G);
  Tss=TSS(A,eta,r,epsilon);

  NEATMflux_W(filter[ifilt].lambda, flux, filter[ifilt].nlambda, Tss, epsilon, D/2, Delta, pha, NITER);

  // TBD: vto 3.6 um ratio is used here and not 3.35 that should be used for WISE
  if (vtobandratio>0) // it adds the relfected comp.
    AddReflComp_W(filter[ifilt].lambda, flux, filter[ifilt].nlambda, H, G, r, Delta, pha, vtobandratio);

  //  printf("%lf %lf %lf %lf %lf %lf %lf\n",A, pV, Tss, epsilon, D/2, Delta, pha);
  //  for (i=0; i<filter[ifilt].nlambda; i++) printf("%lf %lf %e\n",filter[ifilt].lambda[i],filter[ifilt].response[i],flux[i]);
  *isoflux=ComputeIsoFlux(flux,&filter[ifilt],zeropoint[ifilt],&colorcorrection);
  if (verbose) printf("fwisemag: %d %d %lf %lf %lf %lf %lf %lf %e\n", na, ifilt, filtid, a[1], D, pV, eta, vtobandratio, *isoflux);
 
  dyda[1]=*isoflux/D*2;
  //  dyda[1]=(dummymag-*mag);
  dyda[2]=0;
  dyda[3]=0;
  
}


main(int argc, char* argv[])
{
  double	mag[NMAX]; // Magnitude vector
  double        sigmamag[NMAX]; // Magnitude uncertainity vector
  double        filterid[NMAX]; // list of filter vector 
  int		Ndata=0; // Number of data points
  char          ias[4];
  double	Tss;
  int		i,k,itst;
  char*	        filename=NULL;
  double         alamda,chisq,ochisq,*x,*y,*sig,**covar,**alpha;
  double         *a;
  int           *ia;

  double colorcorrection[4];
  char   filtname[4][30]={"w1.interpolated.txt","w2.interpolated.txt","w3.interpolated.txt","w4.interpolated.txt"};
  int ifilt;

  strcpy(ias,"000");

  while (argc>1)
    {
      if (argv[1][0]=='-')
	{
	  switch (argv[1][1])
	    {
	    case 'e':// change the emissivity
	      argc--; argv++; epsilon=atof(argv[1]);
	      break;
	    case 'G'://to change the G
	      argc--; argv++; G=atof(argv[1]);
	      break;
	    case 'p':// change the initial pV
	      argc--; argv++; pV=atof(argv[1]);
	      break;
	    case 'b'://to change the beaming parameter initial value
	      argc--; argv++; eta=atof(argv[1]);
	      break;
	    case 'V':// change the vto band ratio value
	      argc--; argv++; 
	      vtobandratio=atof(argv[1]);
	      break;
	    case 'i':// select parameter to fit e.g. 111 fit all paprameter 100 fit only D 
	      argc--; argv++; 
	      strcpy(ias,argv[1]);
	      break;  
	    case 'h': // show the help
	      printf("%s\n",USAGE);
	      printf("%s\n",ADARGS);
	      return;
	      break;
	    case 'v':
	      verbose=1;
	      break;
	    default:
	      printf("unknown option -%c\n",argv[1][1]);
	      return 0;
	      break;
	    }
	} 
      argc--;
      argv++;
    }


  // load the filters
  for(ifilt=0; ifilt<4; ifilt++)
    LoadFilter(&filter[ifilt], filtname[ifilt]); 

  // DEBUG print a filter
  //  for (i=0; i<w[1].nlambda; i++) printf("%lf %lf %lf\n",w[1].lambda[i],w[1].response[i],w[1].dlambda[i]);


  scanf("%lf %lf %lf %lf", &H, &r, &Delta, &pha); // read the input
  // get data
  Ndata=0;
  while (scanf("%lf %lf %lf", &filterid[Ndata], &mag[Ndata], &sigmamag[Ndata])==3)
    {
      Ndata++;
    }

  if (verbose)
    {
      printf("of data=%d\n", Ndata);
      printf("filt id\t\tmag\t\tmagunc\n");
      for (i=0; i<Ndata; i++)
	printf("%lf\t%lf\t%lf\n", filterid[i], mag[i], sigmamag[i]);
    }


  ia=ivector(1,MA);
  x=vector(1,Ndata);
  y=vector(1,Ndata);
  sig=vector(1,Ndata);
  a=vector(1,MA);
  covar=matrix(1,MA,1,MA);
  alpha=matrix(1,MA,1,MA);
  
  for (i=1;i<=MA;i++) //fill in the what_to_fit array
    if (ias[i-1]=='1') ia[i]=1; else ia[i]=0;

  printf("Converting mags to IsoPhotal Fluxes..\n");
  printf("Filter\tflux(W/m^2/um)\tsigma_flux\n");

  for (i=1; i<=Ndata; i++)
    {
      x[i]=filterid[i-1];
      y[i]=pow(10,-mag[i-1]*0.4)*IsoFluxVega[i-1];
      sig[i]=y[i]*0.92103404*sigmamag[i-1];
      
      printf("%lf\t%e\t%e\n",x[i],y[i],sig[i]);
    }

  a[1]=H2DIAM(H, pV); // guess diameter
  a[2]=eta; // guess eta
  a[3]=vtobandratio;//guess vtobandratio
  
  if (verbose) printf("Fitting parameters ia %d %d %d\n", ia[1],ia[2],ia[3]);
  if (verbose) printf("Initial values %f %f %f\n", a[1],a[2],a[3]);

  if (verbose) 
    {
      printf("---- vectors sent to mrqmin ---- COGNO!\n"); 
      for (i=1; i<=Ndata; i++) printf("%lf\t%e\t%e\n", x[i], y[i], sig[i]);
    }

  // do the LM fit using the NR procudure
  alamda = -1;
  mrqmin(x,y,sig,Ndata,a,ia,MA,covar,alpha,&chisq,fwiseisoflux,&alamda);

  k=1;
  itst=0;
  for (;;) {
    printf("\n%s %2d %17s %10.4f %10s %9.2e\n","Iteration #",k,
	   "chi-squared:",chisq,"alamda:",alamda);
    printf("%8s %8s %8s\n", "D","eta","vtob");
    for (i=1;i<=3;i++) printf("%9.4f",a[i]);
    printf("\n");
    k++;
    ochisq=chisq;
    mrqmin(x,y,sig,Ndata,a,ia,MA,covar,alpha,&chisq,fwiseisoflux,&alamda);
    if (chisq > ochisq)
      itst=0;
    else if (fabs(ochisq-chisq) < 0.1)
      itst++;
    if (itst < 4) continue;
    alamda=0.0;
    mrqmin(x,y,sig,Ndata,a,ia,MA,covar,alpha,&chisq,fwiseisoflux,&alamda);
    
    printf("\nUncertainties:\n");
    for (i=1;i<=3;i++) printf("%9.4f",sqrt(covar[i][i]));
    printf("\n");
    break;
  }
  
  free_matrix(alpha,1,MA,1,MA);
  free_matrix(covar,1,MA,1,MA);
  free_vector(sig,1,Ndata);
  free_vector(y,1,Ndata);
  free_vector(x,1,Ndata);
  free_vector(a,1,MA);
  free_ivector(ia,1,MA);
	
}
#undef NRANSI
